/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.tab.csv;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cz.insophy.inplan.tab.PropertySetter;
import cz.insophy.inplan.tab.PropertySetters;
import cz.insophy.inplan.tab.csv.CsvPropertySetterFactory;
import cz.insophy.inplan.tab.csv.CsvSettings;
import cz.insophy.inplan.util.ExceptionCatchingIterator;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.NameUtils;
import cz.insophy.inplan.util.errlog.ErrorLog;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvLoader {
    private final CSVFormat format;
    private final DateFormat dateTimeFormat;
    private final DateFormat dateFormat;
    private final DecimalFormat numFormat;
    private final ErrorLog errorLog;

    public CsvLoader(@Nonnull ErrorLog errorLog) {
        this.errorLog = errorLog;
        this.numFormat = CsvSettings.getNumberFormat();
        this.dateTimeFormat = CsvSettings.getDateTimeFormat();
        this.dateFormat = CsvSettings.getDateFormat();
        this.format = CsvSettings.getCsvFormat();
    }

    public <T> Iterable<T> load(Reader reader, String sourceName, Class<T> cls, boolean singleton, boolean logErrors) throws IOException {
        List<PropertySetter<String>> propertySetters = PropertySetters.createFor(cls, new CsvPropertySetterFactory(this.dateFormat, this.dateTimeFormat, this.numFormat));
        CSVParser parser = new CSVParser(reader, this.format);
        return () -> new LoadingIterator(cls, propertySetters, parser, sourceName, singleton, logErrors);
    }

    private class LoadingIterator<T>
    implements Iterator<T> {
        private final CSVParser parser;
        private final String sourceName;
        private final boolean singleton;
        private final boolean logErrors;
        private final int fieldCnt;
        private final Class<T> cls;
        private final List<PropertySetter<String>> propertySetters;
        private final Iterator<CSVRecord> recordIterator;
        private final int[] fieldMap;
        private final String[] colNames;
        private final List<RecordLoadingError> recordErrors;
        T next = null;
        T obj = null;

        private void initFieldMap() {
            CSVRecord record = this.recordIterator.next();
            for (int i = 0; i < this.fieldCnt; ++i) {
                String colName = NameUtils.toConstantCase(this.propertySetters.get(i).getFieldName());
                boolean mapped = false;
                for (int j = 0; j < record.size(); ++j) {
                    if (!colName.equalsIgnoreCase(record.get(j))) continue;
                    this.fieldMap[i] = j;
                    this.colNames[i] = colName;
                    mapped = true;
                    break;
                }
                if (mapped) continue;
                throw new IllegalStateException(String.format("Cannot find column %s:%s required to map field %s.%s.", this.sourceName, colName, this.cls.getSimpleName(), this.propertySetters.get(i).getFieldName()));
            }
        }

        LoadingIterator(Class<T> cls, List<PropertySetter<String>> propertySetters, CSVParser parser, String sourceName, boolean singleton, boolean logErrors) {
            this.cls = cls;
            this.propertySetters = propertySetters;
            this.fieldCnt = propertySetters.size();
            this.parser = parser;
            this.sourceName = sourceName;
            this.singleton = singleton;
            this.logErrors = logErrors;
            this.fieldMap = new int[this.fieldCnt];
            this.colNames = new String[this.fieldCnt];
            this.recordErrors = Lists.newArrayListWithCapacity(this.fieldCnt);
            this.recordIterator = new ExceptionCatchingIterator<CSVRecord>(new AligningIterator(parser.iterator()), e -> {
                if (logErrors) {
                    CsvLoader.this.errorLog.add(5, "csv.fatal", "table", sourceName, "record_no", parser.getRecordNumber(), "line_no", parser.getCurrentLineNumber(), "message", "invalid CSV data encountered, parsing stopped");
                }
                return null;
            });
            Preconditions.checkState(!parser.isClosed(), "parser must be open");
            if (this.recordIterator.hasNext()) {
                this.initFieldMap();
            }
            this.loadNext();
            if (this.next == null) {
                this.logErrors();
            }
        }

        private void loadNext() {
            boolean valid;
            Preconditions.checkState(this.recordErrors.isEmpty(), "record errors must be empty");
            do {
                if (!this.recordIterator.hasNext() || this.parser.isClosed()) {
                    this.next = null;
                    try {
                        this.parser.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                CSVRecord record = this.recordIterator.next();
                if (this.next == null || !this.singleton) {
                    try {
                        this.next = this.cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalStateException("Cannot instantiate " + this.cls.getSimpleName(), e);
                    }
                }
                valid = true;
                for (int i = 0; i < this.fieldCnt; ++i) {
                    try {
                        this.propertySetters.get(i).parse(record.get(this.fieldMap[i]), this.next);
                        continue;
                    }
                    catch (Exception e) {
                        String errKey = this.propertySetters.get(i).getCustomError();
                        String msg = (String)(errKey != null ? Localizer.getString(errKey) + " " : "") + e.getMessage();
                        if (this.logErrors) {
                            this.recordErrors.add(new RecordLoadingError(i, record.getRecordNumber() - 1L, this.parser.getCurrentLineNumber(), msg, ImmutableList.copyOf(record.iterator()).toString()));
                        }
                        valid = false;
                    }
                }
            } while (!valid);
        }

        private void logErrors() {
            if (!this.recordErrors.isEmpty()) {
                for (RecordLoadingError rerr : this.recordErrors) {
                    CsvLoader.this.errorLog.add(5, "csv.error", "table", this.sourceName, "col", this.colNames[rerr.colNo], "record_no", rerr.recordNo, "line_no", rerr.lineNo, "message", rerr.message + " - " + rerr.rawRecord);
                }
                this.recordErrors.clear();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            this.logErrors();
            T tmp = this.next;
            this.next = this.obj;
            this.obj = tmp;
            this.loadNext();
            if (this.next == null) {
                this.logErrors();
            }
            return this.obj;
        }
    }

    private static class AligningIterator
    extends AbstractIterator<CSVRecord> {
        private final Iterator<CSVRecord> source;
        private int colCnt = -1;
        private final Constructor<CSVRecord> csvRecordConstructor;

        AligningIterator(Iterator<CSVRecord> source) {
            this.source = source;
            try {
                this.csvRecordConstructor = CSVRecord.class.getDeclaredConstructor(CSVParser.class, String[].class, String.class, Long.TYPE, Long.TYPE);
                this.csvRecordConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected CSVRecord computeNext() {
            if (this.source.hasNext()) {
                int j;
                CSVRecord next = this.source.next();
                int size = next.size();
                if (this.colCnt < 0) {
                    this.colCnt = size;
                }
                if (size >= this.colCnt) {
                    return next;
                }
                String[] res = new String[this.colCnt];
                long recNo = next.getRecordNumber();
                long charPos = next.getCharacterPosition();
                for (j = 0; j < size && j < this.colCnt; ++j) {
                    res[j] = next.get(j);
                }
                while (this.source.hasNext() && j < this.colCnt) {
                    next = this.source.next();
                    int n = --j;
                    res[n] = res[n] + "\n";
                    if (next.size() > 0) {
                        int n2 = j++;
                        res[n2] = res[n2] + next.get(0);
                    }
                    for (int i = 1; i < next.size() && j < this.colCnt; ++j, ++i) {
                        res[j] = next.get(i);
                    }
                }
                try {
                    return this.csvRecordConstructor.newInstance(null, res, null, recNo, charPos);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return (CSVRecord)this.endOfData();
        }
    }

    private static class RecordLoadingError {
        private final int colNo;
        private final long recordNo;
        private final long lineNo;
        private final String message;
        private final String rawRecord;

        RecordLoadingError(int colNo, long recordNo, long lineNo, String message, String rawRecord) {
            this.colNo = colNo;
            this.recordNo = recordNo;
            this.lineNo = lineNo;
            this.message = message;
            this.rawRecord = rawRecord;
        }
    }
}

